+/*!
  \file installation.hpp This file contains documentation only, and is not part of the MynahSA code base.
*/


/*!
 \page installation Installation

 

 \section platforms All Platforms
    <ul>
      <li>Install <a href="http://www.scons.org">SCons</a>, the software construction tool.</li>
      <li>Install <a href="http://www.openssl.org">OpenSSL</a> if your platform does not supply it.  All modern Linux
          distributions supply OpenSSL, however, you may need to install the development packages.</li>
	   <li><strong>Optionally</strong> install <a href="http://www.boost.org">Boost</a>.  Version 1.33.1 is required. 
	       See \ref boost below.</li>
      <li>Edit the top level SConstruct file using your favorite editor.
	     <ul>
	       <li> You will need to specify include and library paths for Boost and OpenSSL only if they are not in your compiler's
	            default include and libraries paths.  For example, if OpenSSL's headers are installed in /usr/include/openssl and libcrypto.so
	            and libssl.so are present in /usr/lib, then you can safely ignore these parameters if your compiler automatically checks these directories.</li>
	       <li>If you wish to compile a debug version of the library set DEBUG=1.  For a release build, set 
	           DEBUG=0.</li>	  
        </ul></li>
      <li>Build the library and tutorials by running scons.</li>
    </ul>


    \section windows Microsoft Windows
    Compilation on Microsoft Windows is easy - However, care must be taken in choosing the correct tool path to
       build <strong>MynahSA</strong> against.  On a straight Win32 system running Visual Studio .NET 2003, you will
       need to install <a href="http://www.activestate.com">ActiveState Python</a>.  Install SCons from inside a
       Visual Studio .NET console window.  This process applies even if you are running 
       <a href="http://www.cygwin.com">Cygwin</a>.  If you install SCons under 
       <a href="http://www.cygwin.com">Cygwin</a> it will assume (by default) that you are using the GNU tool
       chain and insist on using GCC as the default compiler.

    \section boost Notes on Boost Installation
    <strong>MynahSA</strong> provides the option of replacing its internal threading, shared pointer and type traits libraries with
       boost::thread, boost::shared_ptr and boost::type_traits.
    Boost is supplied with a build utility named "jam".  Jam does an excellent job of building the boost software;
       but it does not provide an installation method.  One of the easiest ways to install boost is to create a separate
       target directory, and selectively copy the necessary files there.  For example, one possible directory structure (on 
       Win32) could be:

\verbatim
c:\boost\
         \lib
         \boost
\endverbatim

    Copy all of the .dll files and all of the .lib files into c:\\boost\\lib and use c:\\boost\\lib, and copy 
       the include directory (boost) to c:\\boost\\boost. To avoid copying all of the lib and dll files by hand on 
       windows, install <a href="http://www.cygwin.com">Cygwin</a> and issue the following commands from the boost 
       build directory:
\verbatim
# mkdir /cygdrive/c/boost
# mkdir /cygdrive/c/boost/lib
# cp -r `find . -name "*.dll" -type f` /cygdrive/c/boost/lib/
# cp -r `find . -name "*.lib" -type f` /cygdrive/c/boost/lib/
# cp -r boost /cygdrive/c/boost/
\endverbatim
    Note: The same installation procedure can be performed on UNIX; simply change the name of the path from /cygdrive/c/boost 
    to something like ~/boost and change the file extensions appropriately for Unix: .dll -> .so 
       and .lib -> .a.
    <br><br>
    Once boost is installed, the top level SConstruct file must be edited to cause the build process to use Boost's 
       tools rather than <strong>MynahSA</strong>'s built-in tools.  The changes are fairly trivial.  Start by setting the flag 
       <strong>MYNAHSA_USE_BOOST</strong> to 1.  This automatically defines the preprocessor variable 
       <strong>MYNAHSA_USE_BOOST</strong> at compilation time.  The <strong>MYANHSA_USE_BOOST</strong> variable is
       used to conditionally compile either the boost code path or the internal shared pointer, thread and type 
       traits code.  If the boost libraries are used, this preprocessor variable must be set at compilation time for 
       all programs that use <strong>MynahSA</strong>!
\verbatim
MYNAHSA_USE_BOOST = 1
\endverbatim

      The name of the boost threading library must be specified explicitly.  Boost assigns a name extension to all 
         of its libraries, and the correct one must be chosen to link the <strong>MynahSA</strong> tutorials against.  For a standard 
         GCC/Linux setup the setting would be the following:

\verbatim
#The name of the boost::thread library
BOOST_THREADS_LIBRARY = 'boost_thread-gcc-mt-d-1_33_1'
\endverbatim

      If you have compiled boost yourself, you will most likely need to set 
         <strong>BOOST_REQUIRES_THREADS=1</strong> - this is because Boost's build process builds both threaded and 
         non-threaded versions of its libraries.  Both are usable, however, compiling without specifying 
         <strong>BOOST_HAS_THREADS</strong> causes compile-time errors:
      \verbatim
#If boost requires a BOOST_HAS_THREADS definition, set this to 1.  
#  It is obvious if this is required because error messages stating boost has
#  not been compiled with threads result otherwise.
BOOST_REQUIRES_THREADS = 1
\endverbatim
      Finally, the paths to the boost libraries and include files must be provided if they are not in placed in 
         locations automatically checked by the compiler:
      \verbatim
# The path to the boost libraries.
BOOST_LIB_PATH='/usr/local/lib64/boost-1_33_1'
# The path to the boost include files
BOOST_INC_PATH='/usr/local/include/boost-1_33_1'
\endverbatim

      \section solaris Notes on Solaris
      <strong>MynahSA</strong> is tested on Solaris using the <a href="http://developers.sun.com/prodtech/cc/index.jsp">Sun Studio 11 compiler</a> on x86.  Several patches are required for correct building of the software.  These patches (for x86) are:
      <ul>
	<li>120759 - the Compilers Back-End</li>
	<li>121028 - C++</li>
      </ul>
      These patches are available <a href="http://developers.sun.com/prodtech/cc/downloads/patches/ss11_patches.html">here</a> for both x86 and Sparc platforms.  Note: the patch numbers will be different for the Sparc platform.

*/
