/*!
  \file mainpage.hpp This file contains documentation only, and is not part of the MynahSA code base.
*/

/*! \mainpage MynahSA - Streaming and Archiving Toolkit
 
 
    \section introduction Introduction
    Mynah-Software's streaming and archiving toolkit (<strong>MynahSA</strong>) is a framework for persistent storage and network 
       transmission of C++ objects.  The toolkit provides a simple mechanism for archiving the data of your 
       C++ objects, meaning that one method is used both for reading and writing the data to an archive.  The data 
       produced by archiving an object can be streamed to/from a file or across a network connection using OpenSSL or 
       standard TCP.<br>
       <br>
       <strong>MynahSA</strong> was designed to take the pain out of building efficient client/server applications.  The advantages of using 
       <strong>MynahSA</strong> in your project are:
    <ul>
       <li>Threaded, <a href="http://www.openssl.org">OpenSSL</a> based client/server applications are quickly and easily created.</li>
       <li>Data can be streamed to files with or without strong encryption.</li>
       <li>Cross platform streaming: Write data on a PowerPC, read it on an x86 and vice-versa.</li>
       <li>Cross platform:  <strong>MynahSA</strong> code is portable between Linux/Apple's OSX/ Sun's Solaris and Microsoft's Windows.</li>
       <li><strong>MynahSA</strong> is Open Source Software with professional support.</li>
       <li>It is not <b>XML</b>! - Objects are archived with a minimum excess of data storage.</li>
       <li>Minimal data buffering is used internally: With the exception of a few compiler work-arounds data is not buffered.</li>
       <li>SSL and TCP transports allow for a tradeoff between security and network transmission speed.</li>
    </ul>
  
     \section license License
    <strong>MynahSA</strong> is licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU GPL v2</a>, however, 
       as the sole copyright holder <a href="http://www.mynah-software.com">Mynah-Software Ltd</a> sells 
       licenses for use in commercial programs.  Please contact 
       <a href="mailto:support@mynah-software.com">support@mynah-software.com</a> for further information!
     
  
    \section requirements Requirements
    <ul>
      <li>Windows (Win32): Windows 2000 or newer, Microsoft Visual Studio 2003 compiler.</li>
      <li>Linux: <a href="http://gcc.gnu.org">GNU GCC</a> 3.3 or newer.</li>
      <li>Solaris x86: Sun Studio 11 compiler.</li>
      <li>OSX: gcc version 4.0.0 or newer.</li>
      <li><a href="http://www.scons.org">SCons</a>: For building the library.</li>
      <li><a href="http://www.python.org">Python</a>: For SCons.</li>
    </ul>

    \section contents Contents
    <ul>
      <li>\ref installation </li>
      <li>\ref overview </li>
      <li>\ref tutorial1 </li>
      <li>\ref tutorial2 </li>
      <li>\ref tutorial3 </li>
      <li>\ref tutorial4 </li>
      <li>\ref history </li>
    </ul>
    \section download Download
    <ul>
       <li><a href="http://www.mynah-software.com/packages/mynahsa-0.84.tar.bz2">mynahsa-0.84.tar.bz2</a> - tar bzipped archive.  Source code for unix.</li>
       <li><a href="http://www.mynah-software.com/packages/mynahsa-0.84.tar.gz">mynahsa-0.84.tar.gz</a> - tar gzipped archive.  Source code for unix.</li>
       <li><a href="http://www.mynah-software.com/packages/mynahsa-0.84.zip">mynahsa-0.84.zip</a> - Source code archive for Win32.</li>
    </ul>
    \section support Support
    Support, bug reports and general help are available.  Email: <a href="mailto:support@mynah-software.com">support@mynah-software.com</a>.

 */
