#!/bin/bash

echo "About to make root key and certificate file.  Answer the questions, and avoid defaults."
echo

#generate the root CA
openssl req -x509 -nodes -days 365 -newkey rsa:1024 -keyout rootkey.pem -out rootcert.pem

echo
echo "Creating certificate authority file (CAfile) from root key."
echo
openssl x509 -in rootcert.pem -text > CAfile.pem


echo
echo "About to make server certificate request"
echo
#generate the certificate request
openssl req -nodes -newkey rsa:1024 -keyout serverkey.pem -new  -days 365 -out serverreq.pem

echo
echo "Signing server certificate using root certificate"
echo 
#create the server certificate by issuing it 
openssl x509 -days 180 -CA rootcert.pem -CAkey rootkey.pem -req -CAcreateserial -CAserial serverCA.srl -in serverreq.pem -out servercert.pem

echo
echo "Creating client key request"
echo
openssl req -nodes -newkey rsa:1024 -keyout clientkey.pem -new -days 365 -out clientreq.pem

echo
echo "Issuing client key"
echo 
openssl x509 -days 180 -CA rootcert.pem -CAkey rootkey.pem -req -CAcreateserial -CAserial clientCA.srl -in clientreq.pem -out clientcert.pem

echo "Performing checks:"
echo
echo "Verifying server certificate: "
openssl verify -CAfile CAfile.pem servercert.pem
echo
echo "Verifying client certificate: "
openssl verify -CAfile CAfile.pem clientcert.pem
