/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "pingrequestresponsehandler.hpp"

#include <mynahsa/iobase.hpp>
#include "requestping.hpp"
#include "responseping.hpp"

#include <iostream>

using namespace std;
using namespace MynahSA;

PingRequestResponseHandler::PingRequestResponseHandler()  {
}

PingRequestResponseHandler::~PingRequestResponseHandler() {
}

SHARED_PTR<IoBase> PingRequestResponseHandler::operator()(const SHARED_PTR<IoBase>& req) { 
  SHARED_PTR<IoBase> resp;

  if (req->ioName() == RequestPing().ioName()) { 
#ifdef DEBUG
    cerr << "Ping requested" << endl;
#endif
    SHARED_PTR<RequestPing> prq = STATIC_PTR_CAST<RequestPing>(req);
    // create the response and copy the seconds and microseconds parameters from the request object
    resp = SHARED_PTR<IoBase>(new ResponsePing(true,prq->getUSeconds()));
  } else {
    // this is a logic error; unknown class inserted! 
    cerr << "PingRequestResponseHandler::operator() : Unknown class received." << endl;
  }
    
  return resp;
}
