/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __ping_stream_constructor_hpp
#define __ping_stream_constructor_hpp


#include <mynahsa/mynahsa.hpp>

#include "requestping.hpp"
#include "responseping.hpp"


// build the template constructor classes for RequestPing and ResponsePing
MYNAHSA_BUILD_CONSTRUCTOR(RequestPing);
MYNAHSA_BUILD_CONSTRUCTOR(ResponsePing);

/** Class PingStreamConstructor is used to initialize an IArchive<ISSLStream> instance.  This is necessary since the
 *  SSLArchvieStream has no idea how to reconstruct user supplied classes.  The reconstruction map must be created at
 * runtime, and this constructor function is used to do it.
 */
class PingStreamConstructor : public MynahSA::StreamConstructor { 
public:
  //! constructor - takes no parameters
  PingStreamConstructor();
  
  //! virtual destructor
  virtual ~PingStreamConstructor();
  
  /** the constructor function - generates an SSLArchiveStream, which is copied on return - 
    * the SSL instance instance is passed in as a paramter.
    */
  virtual void operator()(MynahSA::ArchiveStreamBase&) const;
};


#endif
