/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __request_ping_hpp
#define __request_ping_hpp

#include <time.h>

#include <mynahsa/mynahsa.hpp>

#ifdef WIN32
// win32 needs this for struct timeval
#include <winsock2.h>
#endif


/** RequestPing is a server request object.  On client side, 
 *  construct and pass to server.  Server side should handle and return
 *  ResponsePing.
 */
class RequestPing : public MynahSA::IoBase { 
public:

  void serialize(MynahSA::Archive& ar) { 
    ar & _usec;  // serialize useconds
  }
  
  //! default constructor - required to instantiate!
  RequestPing();

  //! construction for restoration off of stream
  RequestPing(unsigned long long tv);

  //! destructor
  virtual ~RequestPing();

  //! identify name of request object
  virtual std::string ioName() const;
  

  //! allow user read access to microseconds
  inline unsigned long long getUSeconds() const { return _usec; }
  
  
private:
  unsigned long long _usec;
};


#endif
