/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __response_ping_hpp
#define __response_ping_hpp

#include <mynahsa/mynahsa.hpp>


/** ResponsePing is a server response object.  This object is created
 *  by the server in response to a ping request.
 */
class ResponsePing : public MynahSA::IoBase { 
public:

  void serialize(MynahSA::Archive& ar) { 
    ar & _ok;
    ar & _usec;
  }

  //! construction for restoration off of stream
  ResponsePing(bool ok=false, unsigned long long usec=0);
  
  //! destructor
  virtual ~ResponsePing();

  //! identify name of the response object
  virtual std::string ioName() const;

  //! return true - indicates server is ok.  False; otherwise
  bool isOk() const { return _ok; }
  
  //! allow user read access to microseconds
  inline unsigned long long getUSeconds() const { return _usec; }

private:
  //! indicate to the client that everything is ok here.
  bool _ok;
  
  //! microseconds recorded at client
  unsigned long long _usec;
};


#endif
