/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __extended_person_record_hpp
#define __extended_person_record_hpp

#include "personrecord.hpp"

#include <mynahsa/archive.hpp>
#include <mynahsa/iobase.hpp>

#include <mynahsa/spimpl.hpp>

#include <list>

class ExtendedPersonRecord : public PersonRecord, public MynahSA::IoBase { 
public:
  //! default constructor
  ExtendedPersonRecord();
  
  //! parameter constructor
  ExtendedPersonRecord(std::string name, int age, PersonRecord::EyeColor ec);

  //! destructor - needs to do nothing; destruction by SHARED_PTR is automatic
  ~ExtendedPersonRecord();
  
  //! ioName - return the name of this class type.  Reimplementation from MynahSA::IoBase
  std::string ioName() const;
  
  //! serialize - reimplementation from MynahSA::IoBase
  void serialize(MynahSA::Archive& ar);
  
  //! get access to the list of friends
  const std::list< SHARED_PTR< ExtendedPersonRecord > >& getFriends() const;
  
  //! add a friend to the list of friends
  void addFriend(SHARED_PTR< ExtendedPersonRecord > newFriend);

private:
  //! internal list of friends
  std::list< SHARED_PTR<ExtendedPersonRecord> > _friends;

};



#endif
