/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/iblowfishstream.hpp>
#include <mynahsa/oblowfishstream.hpp>

#include <mynahsa/iarchive.hpp>
#include <mynahsa/oarchive.hpp>

#include <sstream>

#include <string>


using namespace MynahSA;
using namespace std;


// simple container for storing a name and an age.  Serialize method is similar to others.
struct SimpleContainer { 
  void serialize(Archive& ar) { 
    ar & _name;
    ar & _age;
  }

  string _name;
  int _age;
};


int main() { 
  ostringstream ostr;
  { 
    SimpleContainer sc;
    sc._name = "Brett";
    sc._age = 32;
    
    OBlowfishStream obfs(ostr, "Private Key");
    OArchive<OBlowfishStream> oabfs(obfs);
    
    oabfs << sc;
  }
  
  for (unsigned int i=0; i<ostr.str().size(); i++) { 
    unsigned char ch = ostr.str()[i];
    cout << "Stream[" << i << "] contains value: " << ((unsigned int) ch) << endl;
  }
  cout << endl;
  
  {
    SimpleContainer sc;
    istringstream istr(ostr.str());
    IBlowfishStream ibfs(istr, "Private Key");
    IArchive<IBlowfishStream> iabfs(ibfs);
    iabfs >> sc;
    cout << "sc's name: " << sc._name << endl;
    cout << "sc's age: " << sc._age << endl; 
  }
  
}
