/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <iostream>

#include <mynahsa/tcprpcserver.hpp>

#include "pingrequestresponsehandler.hpp"
#include "pingstreamconstructor.hpp"

#include <mynahsa/tcpconnectionmanager.hpp>

#include <mynahsa/sainit.hpp>

#include <mynahsa/spimpl.hpp>


#include <mynahsa/stringcast.hpp>

#include <mynahsa/serverexception.hpp>

using namespace std;
using namespace MynahSA;

void usage() {
  cerr << "Usage: " << endl;
  cerr << " server  [-port <int>]" << endl;
  cerr << " where:" << endl;
  cerr << "   -port <int> specifies the port to operate on" << endl;
}

int main(int argc, char** argv) { 
  saInit();
  try { 
    // hard assign the server port for this example
    int serverPort = 7501;
    int i=1;
    while (i<argc) { 
      if (string(argv[i]) == "-port") { 
        i++;
        if (i >= argc) { 
          usage();
          return 1;
        }
        serverPort = StringCast<int>(argv[i]);
      } else { 
        usage();
        exit(1);
      }
      i++;
    }

    // step 1: build the ping request response handler
    PingRequestResponseHandler prh;
    
    // step 2: create the stream constructor object.
    PingStreamConstructor myConstructor;
  
    // step 4: instantiate a connection manager on the handler and the stream constructor
    TCPConnectionManager cm(prh,
                            myConstructor);
                                              
    // step 5: build an ssl server on top of the connection manager instance
    TCPRPCServer server(cm, serverPort); 
    
    // step 6: enter loop where we serve requests forever
    while (1) { 
      try { 
        server.checkClients(5);
      } catch (const ServerConnectionException& sce) { 
        cerr << "Connection exception detected: " << sce.what() << endl;
      }
    }      
  } catch (const ServerException& se) { 
    cerr << "Fatal server exception occurred: " << se.what() << endl;
  }
}
