/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "databasefiledriver.hpp"

using namespace std;

DatabaseFileDriver::DatabaseFileDriver(const string& fileName) : _db(fileName) {
}

DatabaseFileDriver::~DatabaseFileDriver() {
}


DBResult DatabaseFileDriver::queryName(const std::string& nameStart, const std::string& nameEnd) const {
  return _db.queryName(nameStart, nameEnd);
}

DBResult DatabaseFileDriver::queryAge(int ageStart, int ageEnd) const {
  return _db.queryAge(ageStart, ageEnd);
}

DBResult DatabaseFileDriver::queryEyeColor(PersonRecord::EyeColor ec) const {
  return _db.queryEyeColor(ec);
}

DBResult DatabaseFileDriver::queryAll() const {
  return _db.queryAll();
}

DBResult DatabaseFileDriver::modifyRecord(unsigned int uid, 
                      const std::string& name,
                      int age,
                      PersonRecord::EyeColor ec) {
  spRecord rec(new ExtendedPersonRecord(name, age, ec));
  return _db.modifyRecord(uid, rec);
}                      

DBResult DatabaseFileDriver::deleteRecord(unsigned int uid) {
  return _db.deleteRecord(uid);
}

DBResult DatabaseFileDriver::insertRecord(const std::string& name,
                      int age,
                      PersonRecord::EyeColor ec) {
  spRecord rec(new ExtendedPersonRecord(name, age, ec));                     
  return _db.insertRecord(rec);  
}                      
