/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __database_file_driver_hpp
#define __database_file_driver_hpp

#include "database.hpp"
#include "databasedriver.hpp"
#include <string>

/** class DatabaseFileDriver is a simple driver wrapper for an instance of class Database.
 *  This class is just a message passer - an interface between the database implementation (class Database)
 *  and the command proceessor (class Parser).
 */
class DatabaseFileDriver : public DatabaseDriver { 
public:
  /**
   * Constructor - instantiates a database on the a specific file
   * @param filename - the filename for the database
   * @return Nothing
   */
  DatabaseFileDriver(const std::string& filename);
  
  /**
   * Destructor - Note: this writes the Database instance onto the filename provided in the constructor
   * @return Nothing
   */
  ~DatabaseFileDriver();
  
  //! name search
  DBResult queryName(const std::string& nameStart, const std::string& nameEnd) const;
  
  //! age search
  DBResult queryAge(int ageStart, int ageEnd) const;
  
  //! eye color search
  DBResult queryEyeColor(PersonRecord::EyeColor) const;
  
  //! return all hits
  DBResult queryAll() const;
  
  //! modify a record, specified by uid
  DBResult modifyRecord(unsigned int uid, 
                        const std::string& name,
                        int age,
                        PersonRecord::EyeColor ec);
                        
  //! delete a record by uid                        
  DBResult deleteRecord(unsigned int uid);
  
  //! insert a record
  DBResult insertRecord(const std::string& name,
                        int age,
                        PersonRecord::EyeColor ec);

private:
  //! database instance
  mutable Database _db;


};


#endif
