/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "databasesslrpcdriver.hpp"  
  
#include "dbrequest.hpp"
  
using namespace MynahSA;
using namespace std;


DatabaseSSLRPCDriver::DatabaseSSLRPCDriver(SSLRPCClient& client) : _client(client) {
}


DatabaseSSLRPCDriver::~DatabaseSSLRPCDriver() {
}

DBResult DatabaseSSLRPCDriver::rpcIt(const SHARED_PTR<IoBase>& req) const { 
  SHARED_PTR<IoBase> ptr(_client.rpc(req));
  if (ptr->ioName() == "DBResult") { 
    return *STATIC_PTR_CAST<DBResult>(ptr);
  } else { 
    throw logic_error("DatabaseSSLRPCDriver::rpcIt - failed to convert IoBase pointer to DBResult pointer");
  }
};

DBResult DatabaseSSLRPCDriver::queryName(const string& nameStart, const string& nameEnd) const {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::QUERY_NAME));
  dbr->_name = nameStart;
  dbr->_name2 = nameEnd;
  return rpcIt(dbr);
}

DBResult DatabaseSSLRPCDriver::queryAge(int ageStart, int ageEnd) const {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::QUERY_AGE));
  dbr->_age = ageStart;
  dbr->_age2 = ageEnd;
  return rpcIt(dbr);
}

DBResult DatabaseSSLRPCDriver::queryEyeColor(PersonRecord::EyeColor ec) const {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::QUERY_EYE_COLOR));
  dbr->_eyeColor = ec;
  return rpcIt(dbr);
}
  
DBResult DatabaseSSLRPCDriver::queryAll() const {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::QUERY_ALL));

  
  return rpcIt(dbr);
}


DBResult DatabaseSSLRPCDriver::modifyRecord(unsigned int uid, 
                                            const string& name,
                                            int age,
                                            PersonRecord::EyeColor ec) {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::MODIFY_RECORD));
  dbr->_name = name;
  dbr->_uid = uid;
  dbr->_age = age;
  dbr->_eyeColor = ec;                                            
  return rpcIt(dbr);
}
                                            
DBResult DatabaseSSLRPCDriver::deleteRecord(unsigned int uid) {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::DELETE_RECORD));
  dbr->_uid = uid;
  return rpcIt(dbr);
}

DBResult DatabaseSSLRPCDriver::insertRecord(const string& name,
                                            int age,
                                            PersonRecord::EyeColor ec) {
  SHARED_PTR<DBRequest> dbr(new DBRequest(DBRequest::INSERT_RECORD));
  dbr->_name = name;
  dbr->_age = age;
  dbr->_eyeColor = ec;
                                 
  return rpcIt(dbr);
}
