/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "dbregister.hpp"

#include <mynahsa/archive.hpp>

using namespace MynahSA;

DBRegister::DBRegister() {
}

DBRegister::~DBRegister() {
}

void DBRegister::operator()(Archive& ar) const {
  MYNAHSA_REGISTER_CONSTRUCTOR(ar, Database);
  MYNAHSA_REGISTER_CONSTRUCTOR(ar, ExtendedPersonRecord);
  MYNAHSA_REGISTER_CONSTRUCTOR(ar, DBRequest);
  MYNAHSA_REGISTER_CONSTRUCTOR(ar, DBResult);
}

void DBRegister::operator()(MynahSA::ArchiveStreamBase& as) const {
  MYNAHSA_REGISTER_CONSTRUCTOR(as, Database);
  MYNAHSA_REGISTER_CONSTRUCTOR(as, ExtendedPersonRecord);
  MYNAHSA_REGISTER_CONSTRUCTOR(as, DBRequest);
  MYNAHSA_REGISTER_CONSTRUCTOR(as, DBResult);
}

