/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __db_register_hpp
#define __db_register_hpp

#include <mynahsa/iarchiveregister.hpp>
#include "database.hpp"
#include "extendedpersonrecord.hpp"
#include "dbrequest.hpp"
#include "dbresponse.hpp"


#include <mynahsa/streamconstructor.hpp>

MYNAHSA_BUILD_CONSTRUCTOR(Database);
MYNAHSA_BUILD_CONSTRUCTOR(ExtendedPersonRecord);

// network io classes
MYNAHSA_BUILD_CONSTRUCTOR(DBRequest);
MYNAHSA_BUILD_CONSTRUCTOR(DBResult);

/** Class implementation for registering constructors.
  */
class DBRegister : public MynahSA::StreamConstructor {
public:
  
  /**
   * Default constructor
   * @return nothing
   */
  DBRegister();
  
  /**
   * Default destructor
   * @return nothing
   */
  ~DBRegister();
  
  /**
   * Register an input archive instance with the necessary classes.
   * @param ar - the archive instance to register
   */
  void operator()(MynahSA::Archive& ar) const;
  
  
  /**
   * Second operator for stream usage - allows this object to be dual purpose
   * @param as - archive stream
   */
  void operator()(MynahSA::ArchiveStreamBase& as) const;
  
};



#endif
