/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "dbrequest.hpp"

using namespace std;
using namespace MynahSA;

DBRequest::DBRequest() : _request(UNKNOWN), 
                         _age(0), 
                         _age2(0),
                         _uid(0) {
}

DBRequest::DBRequest(DBRequest::RequestType req) : _request(req),  
                                                   _age(0), 
                                                   _age2(0),
                                                   _uid(0) {
}

DBRequest::~DBRequest() { 
}

string DBRequest::ioName() const { 
  return "DBRequest";
}

void DBRequest::serialize(Archive& ar) { 
  ar & _request;
  ar & _name;
  ar & _name2;
  ar & _age;
  ar & _age2;
  ar & _uid;
  ar & _eyeColor;
};
