/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "dbrequestresponsehandler.hpp"

#include "dbrequest.hpp"

using namespace MynahSA;
using namespace std;



DBRequestResponseHandler::DBRequestResponseHandler(Database& db) : _db(db) {  // initialize local reference
}


DBRequestResponseHandler::~DBRequestResponseHandler() {
}

SHARED_PTR<MynahSA::IoBase> DBRequestResponseHandler::operator()(const SHARED_PTR<IoBase>& req) { 
  cerr << "Got an object with name: " << req->ioName() << endl;
  if (req->ioName() == DBRequest().ioName()) {
    SHARED_PTR<DBRequest> dbreq = STATIC_PTR_CAST<DBRequest>(req);
    
    // now: analyze dbreq and perform necessary actions
    DBResult result;
    switch (dbreq->_request) { 
    case DBRequest::QUERY_NAME:
      cerr << "DBRequest::QUERY_NAME" << endl;
      result = _db.queryName( dbreq->_name, dbreq->_name2 );
      break;
    case DBRequest::QUERY_AGE:
          cerr << "DBRequest::QUERY_AGE" << endl;
      result = _db.queryAge( dbreq->_age, dbreq->_age2 );
      break;
    case DBRequest::QUERY_EYE_COLOR:
          cerr << "DBRequest::QUERY_EYE_COLOR" << endl;
      result = _db.queryEyeColor( dbreq->_eyeColor );
      break;
    case DBRequest::QUERY_ALL:
          cerr << "DBRequest::QUERY_ALL" << endl;
      result = _db.queryAll();
      break;
    case DBRequest::MODIFY_RECORD:
          cerr << "DBRequest::MODIFY_RECORD" << endl;
      result = _db.modifyRecord( dbreq->_uid, spRecord(new ExtendedPersonRecord(dbreq->_name, dbreq->_age, dbreq->_eyeColor) ) );
      break;
    case DBRequest::DELETE_RECORD:
          cerr << "DBRequest::DELETE_RECORD" << endl;
      result = _db.deleteRecord( dbreq->_uid );
      break;
    case DBRequest::INSERT_RECORD:
          cerr << "DBRequest::INSERT_RECORD" << endl;
      result = _db.insertRecord(spRecord( new ExtendedPersonRecord(dbreq->_name, dbreq->_age, dbreq->_eyeColor) ) );
      break;
    default:
          cerr << "UNKNOWN!" << endl;
      result = DBResult(DBResult::Error, "Unknown request", DBHitList());
    };
    
    // return by copy construction.  Note: this is only a small performance penalty, for performance critical applications, working in
    // shared pointers during the calculation above may be preferable.
    return SHARED_PTR<IoBase>(new DBResult(result));
    
  } else { 
    throw logic_error("Error, invalid request object");
  }
}
