/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __db_request_response_handler_hpp
#define __db_request_response_handler_hpp

#include <mynahsa/requestresponsehandler.hpp>
#include "database.hpp"

#include <mynahsa/spimpl.hpp>


/** class DBRequestResponseHandler - take a DBRequest operation, perform it on the 
 *  database instance held by reference in this class, and return a DBResult object.<br>
 *  <br>
 *  This class implements the server behavior for the database server.
 */
class DBRequestResponseHandler : public MynahSA::RequestResponseHandler { 
public:
  /**
   * Constructor - requires a reference to the database instance.
   * @param db - Database reference
   * @return - Nothing
   */
  DBRequestResponseHandler(Database& db);
  
  /**
   * Destructor
   * @return - Nothing
   */
  ~DBRequestResponseHandler();
    
  /**
   * Operator method - take one IoBase object identify it as as a DBRequest, perform the
   * request and return the response to the request.
   * @param  req - the incoming request
   * @return - the response object
   */
  SHARED_PTR<MynahSA::IoBase> operator()(const SHARED_PTR<MynahSA::IoBase>& req);
  
private:
  //! hold a private reference to the single database instance!
  Database& _db;
};

#endif
