/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "dbresult.hpp"

using namespace std;

using namespace MynahSA;

#include <iostream>
using namespace std;

// default constructor - sets result to undefined
DBResult::DBResult() : _result(DBResult::Undefined) { 
}

// specific parameter constructor - note: this shallow-copies the hit list
DBResult::DBResult(DBResult::Result res, const string& what, const DBHitList& hits) : _result(res),
                                                                                      _whatString(what),
                                                                                      _hits(hits) {
}

// copy constructor - shallow copy
DBResult::DBResult(const DBResult& result) : _result(result._result),
                                             _whatString(result._whatString),
                                             _hits(result._hits) { 
                                                                                        
}

DBResult::~DBResult() { 
  // nothing to do
}

string DBResult::ioName() const { 
  return "DBResult";
}

void DBResult::serialize(Archive& ar) { 
  ar & _result;
  ar & _whatString;
  ar & _hits;
};

const DBHitList& DBResult::getHits() const { 
  return _hits;
}

const string& DBResult::what() const { 
  return _whatString;
} 


ostream& operator<<(ostream& os, const DBResult& r) {
  if (! r.isOk()) { 
    os << "Error: " << r.what();
  } else { 
    os << r.getHits();
  }
  return os;
}


