/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "dbtypedef.hpp"
using namespace std;

ostream& operator<<(ostream& os, const DBHit& dbHit) { 
  os << "Unique id: " << dbHit.first << endl;
  os << (*(dbHit.second));
  return os;
}


ostream& operator<<(ostream& os, const DBHitList& dbHits) {
  for (DBHitList::const_iterator cit = dbHits.begin();
       cit != dbHits.end();
       ++cit) { 
    os << (*cit) << endl;    
  }
  return os;
}
