/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __db_typedef_hpp
#define __db_typedef_hpp

#include "extendedpersonrecord.hpp"

#include <mynahsa/spimpl.hpp>


#include <utility>
#include <list>

#include <iostream>

//! simplification to avoid typing!
typedef SHARED_PTR<ExtendedPersonRecord> spRecord;

//! A Hit is a unique identifying integer for the record, and a pointer to the record
typedef std::pair<unsigned int, spRecord > DBHit;

//! A Hit list is (as expected) a list of hits
typedef std::list<DBHit> DBHitList;


/**
 * Output a DBHit onto std::stream as a formatted output
 * @param os - output stream
 * @param dbHit - hit to be printed
 * @return - ostream& after streaming of dbHit
 */
std::ostream& operator<<(std::ostream& os, const DBHit& dbHit);

/**
 * Output a list of DBHits onto std::stream as formatted output
 * @param os - output stream
 * @param dbHits - the hitlist
 * @return - os after streaming of hitlist
 */
std::ostream& operator<<(std::ostream& os, const DBHitList& dbHits);


#endif
