/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

// a direct database test:
//   access and use a database from a file.
//   read commands from stdin, process them on the database.
//   report errors if they occur.
//   write the database to disk on exit

#include <iostream>
#include <string>
#include "databasefiledriver.hpp"
#include "parser.hpp"

using namespace std;

int main() {
  //! create a database instance on testdb.dat
  DatabaseFileDriver myDriver("testdb.dat");
  
  //! build a parser on the file driver
  Parser myParser(myDriver);
  
  string cmd;
  // write the prompt
  cout << "> "; cout.flush();
  // while data is available, loop:
  while (getline(cin, cmd)) {
    try {
      if (!cmd.empty()) { 
        // parse command, write result
        DBResult res = myParser(cmd);
        cout << res << endl;
      }
    } catch (logic_error& le) { 
      cerr << le.what() << endl;
    }
    cout << "> "; cout.flush();
  }
}
