/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "extendedpersonrecord.hpp"

using namespace std;
using namespace MynahSA;

ExtendedPersonRecord::ExtendedPersonRecord() { 
}

ExtendedPersonRecord::ExtendedPersonRecord(string name, int age, PersonRecord::EyeColor ec) : PersonRecord(name, age, ec) { 
}

ExtendedPersonRecord::~ExtendedPersonRecord() { 
}

string ExtendedPersonRecord::ioName() const {
  return "ExtendedPersonRecord";
}
 
void ExtendedPersonRecord::serialize(Archive& ar) { 
  PersonRecord::serialize(ar);  // base class serialization
  ar & _friends;                // serialize friends
}

const list< SHARED_PTR< ExtendedPersonRecord > >& ExtendedPersonRecord::getFriends() const {
  return _friends;
}

void ExtendedPersonRecord::addFriend(SHARED_PTR< ExtendedPersonRecord > newFriend) {
  _friends.push_back(newFriend);
}

ostream& operator<<(ostream& os, const ExtendedPersonRecord& epr) { 
  os << static_cast<const PersonRecord&>(epr);
  os << "Friends: ";
  for (list< SHARED_PTR< ExtendedPersonRecord > >::const_iterator cit = epr.getFriends().begin();
       cit != epr.getFriends().end();
       ++cit) { 
    os << (*cit)->_name << " ";
  }
  os << endl;
  return os;
}
