/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __parser_hpp
#define __parser_hpp

#include "databasedriver.hpp"
#include "dbresult.hpp"

/**
 * class Parser - a naive parser that handles a single line at a time, parses the command and
 * invokes operations on the database driver as a result.
 */
class Parser { 
public:
  /**
   * Parser constructor - takes a database driver reference.
   * @param dbd - reference to database driver
   * @return - nothing
   */
  Parser(DatabaseDriver& dbd);

  /**
   * Parse a single command
   * @param s - the command
   */
  DBResult operator()(const std::string& s);

private:
  //! the driver reference
  DatabaseDriver& _driver;

};




#endif
