/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "personrecord.hpp"

using namespace MynahSA;
using namespace std;

PersonRecord::PersonRecord() : _name(""),
                               _age(0),
                               _eyeColor(Undefined) { 
}                               

PersonRecord::PersonRecord(std::string name, int age, PersonRecord::EyeColor ec) : _name(name), 
                                                                                   _age(age),
                                                                                   _eyeColor(ec) {
}

void PersonRecord::serialize(Archive& ar) { 
  ar & _name;
  ar & _age;
  ar & _eyeColor;
}


std::ostream& operator<<(std::ostream& os, const PersonRecord& r) {
  os << "Name: " << r._name << endl;
  os << "Age:  " << r._age << endl;
  os << "Eye Color: ";
  switch (r._eyeColor) { 
  case PersonRecord::Red:
    os << "Red";
    break;
  case PersonRecord::Blue:
    os << "Blue";
    break;
  case PersonRecord::Green:
    os << "Green";
    break;
  case PersonRecord::Brown:
    os << "Brown";
    break;
  default:
    os << "Unknown, value is: " << r._eyeColor;
  };
  os << endl;
  
  return os;
};
