/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __person_record_hpp
#define __person_record_hpp

#include <iostream>

#include <mynahsa/archive.hpp>

/** struct PersonRecord is a simple data structure for containing a person's data.
  */
struct PersonRecord { 
  enum EyeColor { Undefined, Red, Blue, Green, Brown };
  
  //! default constructor - required for STL type instantiation
  PersonRecord();  
  
  //! constructor with parameters - for a 1 line PersonRecord specification
  PersonRecord(std::string name, int age, EyeColor ec);
  
  //! the person's name
  std::string _name;
  //! age
  int _age;
  //! and eye color
  EyeColor _eyeColor;
  
  //! archiving method
  void serialize(MynahSA::Archive& ar);
  
  
};

//! display output directly onto std::stream
std::ostream& operator<<(std::ostream& os, const PersonRecord& r);
  




#endif
