/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __archive_stream_base_hpp
#define __archive_stream_base_hpp    
    
#include <string>
#include <mynahsa/spimpl.hpp>

#include <mynahsa/archive.hpp>
    
namespace MynahSA { 
  class ArchiveStreamBase {     
  public:
    virtual void registerConstructor(const std::string& name, 
                             const SHARED_PTR<Archive::ArchiveConstructor>& cons) = 0;
                             
  };                             
}; // MynahSA namespace                             
#endif          
