/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __byte_swap_hpp
#define __byte_swap_hpp

// simple recursive template declaration for swapping byte order


namespace MynahSA {
  
  template<int N>
  inline void swapit_helper(char* a, char* b) { 
    std::swap(*a, *b);
    swapit_helper<N-1>(a+1, b-1);
  }
  
  template<>
  inline void swapit_helper<0>(char* a, char* b) {
  }
  
  
  template<class T>
  inline void byteswap(T& i) {
    swapit_helper< sizeof(T)/2 >( ((char*) &i), ((char*)&i)+sizeof(T)-1);
  }

}
#endif
