/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/exceptionbase.hpp>

namespace MynahSA { 
  class ClientException : public ExceptionBase { 
  public:
    enum ErrorCode {
      CLIENT_ERROR_BIND,
      CLIENT_ERROR_CONNECT,
      CLIENT_ERROR_CREATE_SOCKET,
      CLIENT_ERROR_SOCKET_REUSE,
      SSLRPCCLIENT_ERROR_SSL_CONTEXT_CREATION,
      SSLRPCCLIENT_ERROR_SSL_NEW,
      SSLRPCCLIENT_ERROR_SSL_CONNECT,
      CLIENT_ERROR_WRITE,
      CLIENT_ERROR_READ,
      SSLRPCCLIENT_ERROR_LOAD_CERT,
      SSLRPCCLIENT_ERROR_LOAD_PKEY,
      SSLRPCCLIENT_PKEY_INVALID,
      CLIENT_NO_ADDRESS,
      CLIENT_ADDRESS_CONVERSION_ERROR
    };
    
    /**
     * Constructor - takes the error code as a construction time parameter.
     * @param code - the code for the error
     * @return 
     */
    ClientException(ErrorCode code) throw();
  
   
    /**
     * Destructor
     * @return - Nothing
     */
    ~ClientException() throw();
  
    /**
     * Return the string describing the error
     * @return - the error string
     */
    const char* what() const throw();
    
  private:
    ErrorCode _ec;
  }; // class ClientException



}; // namespace MynahSA
