/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __i_archive_register_hpp
#define __i_archive_register_hpp

/** \file iarchiveregister.hpp
 *  This file is responsible for registering all specific i/o classes with an 
 *  iarchive instance.  The purpose of this is to simplify (as much as possible)
 *  the registration process.  All network transmissable classes must be registered.
 */

#include "iobase.hpp"
#include "archive.hpp"

#include <mynahsa/spimpl.hpp>


// This macro defines a class named XConstrcutor where X is replaced by the macro name.
// The purpose of this macro is to simplify the definition of a constructor class for
// the input archive handler.
//
// Each class to be handled by the input archive handler must have this macro used
// for it to define a constructor object.

#define MYNAHSA_BUILD_CONSTRUCTOR( X ) \
class X##Constructor : public MynahSA::Archive::ArchiveConstructor { \
 public: \
  X##Constructor() { } \
  ~X##Constructor() { } \
  SHARED_PTR<MynahSA::IoBase> operator()() const { \
    SHARED_PTR< X > rv(new X); \
    return rv; \
  } \
};

// This macro is used to insert a class constructor into an iarchive instance.
// the macro paramaters are: Input Archive (or Archive) IA, Instance
#define MYNAHSA_REGISTER_CONSTRUCTOR( IA, TypeName ) IA.registerConstructor( TypeName().ioName(), \
							     SHARED_PTR< MynahSA::Archive::ArchiveConstructor >(new TypeName##Constructor))


#endif
