/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __i_binary_stream_hpp
#define __i_binary_stream_hpp

#include <iostream>

#include "istreambase.hpp"

namespace MynahSA { 

  /** Class IBinaryStream couples the archive system with a standard stream.  The BinaryStream
  *  variety writes data onto the stream in a formated binary mode.  Integers, floats, doubles,
  *  etc... are written directly onto the std::istream provided in class construction.  Note: 
  *  unlike network byte order - the default byte order for this system is Intel standard; not
  *  big endian.  There are not that many big-endian platforms around anymore :(.
  */
  class IBinaryStream : public IStreamBase { 
  public:
    //! constructor - takes an input stream
    IBinaryStream(std::istream& is);
    
    //! copy constructor
    IBinaryStream(const IBinaryStream& is);
    
    //! destructor - does nothing
    virtual ~IBinaryStream();
    
    //! instream a char
    virtual IStreamBase& operator>>(char&);
    
    //! instream an unsigned char
    virtual IStreamBase& operator>>(unsigned char&);
    
    //! instream a short
    virtual IStreamBase& operator>>(short&);
    
    //! instream an unsigned short
    virtual IStreamBase& operator>>(unsigned short&);
    
    //! instream a bool
    virtual IStreamBase& operator>>(bool&);
    
    //! instream an int
    virtual IStreamBase& operator>>(int&);
    
    //! instream an unsigned int
    virtual IStreamBase& operator>>(unsigned int&);
    
    //! instream a long long
    virtual IStreamBase& operator>>(long long&);
    
    //! instream an unsigned long long
    virtual IStreamBase& operator>>(unsigned long long&);
    
    //! instream a double
    virtual IStreamBase& operator>>(double&);
    //! instream a float
    virtual IStreamBase& operator>>(float&);
  
    //! implementation for get char
    virtual void get(char& c);
    
    // use base class implementations
    using IStreamBase::operator>>;
  
  private:
    //! input stream reference
    std::istream& _is;
  };
};

#endif
