/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __i_blowfish_stream_hpp
#define __i_blowfish_stream_hpp

#include <mynahsa/istreambase.hpp>

#include <openssl/blowfish.h>

#include <iostream>

#include <string>

namespace MynahSA { 
  class IBlowfishStream : public IStreamBase { 
  public:
  
    /** Constructor - this const
     * 
     * @param is - the std::istream that this instance will use as a data source
     * @param key - the key to decrypt the data on the input stream
     */
    IBlowfishStream(std::istream& is, const std::string& key);
    
    /** Copy constructor
     * 
     * @param is - the input stream to be copied
     */
    IBlowfishStream(const IBlowfishStream& is);
    
    //! virtual destructor
    virtual ~IBlowfishStream();
    
    //! instream a char
    virtual IStreamBase& operator>>(char&);
    
    //! instream an unsigned char
    virtual IStreamBase& operator>>(unsigned char&);
    
    //! instream a short
    virtual IStreamBase& operator>>(short&);
    
    //! instream an unsigned short
    virtual IStreamBase& operator>>(unsigned short&);
    
    //! instream a bool
    virtual IStreamBase& operator>>(bool&);
    
    //! instream an int
    virtual IStreamBase& operator>>(int&);
    
    //! instream an unsigned int
    virtual IStreamBase& operator>>(unsigned int&);
    
    //! instream a long long
    virtual IStreamBase& operator>>(long long&);
    
    //! instream an unsigned long long
    virtual IStreamBase& operator>>(unsigned long long&);
    
    //! instream a double
    virtual IStreamBase& operator>>(double&);
    
    //! instream a float
    virtual IStreamBase& operator>>(float&);
    
   
    //! get function implements character level input - it is unformatted - and will read 1 chr at a time
    virtual void get(char& c);
    
    
    // using declaration to make base string method accessible
    using IStreamBase::operator>>;
    
  private:
  
    /** Load data off of stream into buffer and decrypt
     * 
     */
    void fillBuffer();
  
  
    //! input stream reference
    std::istream& _is;
    
    //! blowfish key structure
    BF_KEY _bfKey;
    
    unsigned int _buffPtr;
    
    //! input buffer - holds encrypted data
    unsigned char _inBuffer[8];
    
    //! output buffer - holds decrypted data
    unsigned char _outBuffer[8];
    
    //! blowfish state vector
    unsigned char _ivec[8];
    

  };  // class IBlowfishStream
};  // namespace MynahSA

#endif
