/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __iobase_hpp
#define __iobase_hpp

#include <string>

namespace MynahSA { 
  // forward declaration
  class Archive;
  
  /** Class IoBase is a class base used for all objects transmitted between client
  *  and server.  It is a polymorphic base class to allow common code paths to 
  *  be unified through virtual member functions.<br>
  *
  *  This class is a replacement for base classes Request and Response which were
  *  designed to work with boost's serialization library.  The serialization library
  *  was deemed to be too cumbersome for this project.
  */
  class IoBase {
  public:
    //! constructor
    IoBase();
    //! destructor 
    virtual ~IoBase();
  
    //! serialization place holder - does nothing in the pure base
    virtual void serialize(Archive& ar) = 0;
  
    //! return the name of the io class.
    virtual std::string ioName() const=0;
  };
};
#endif
