/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __i_tcp_stream_hpp
#define __i_tcp_stream_hpp

#include <iostream>

#include <stdexcept>

#include <string>


#include "istreambase.hpp"

namespace MynahSA { 


  /** Class ITCPStream is an input stream designed to restore the builtin C++ types from a TCP stream
  *    The class operates by calling TCP_read(...) once for each type.<br>
  *
  *    This class does not take ownership of the TCP object passed into it.  The user is responsible
  *    for correct cleanup of the TCP, and furthermore, ensuring that isntances of ITCPStream do not
  *    use the TCP* after it is closed!<br>
  *
  *  Note: This class makes no attempt to abstract buffering of data.  Should it be necessary, this
  *    will be implemented later on.<br>
  */
  class ITCPStream : public IStreamBase {
  public:
    //! constructor - takes a socket descriptor as input
    ITCPStream(int s);
  
    /** Copy constructor - use with caution! This constructor takes direct copies of the underlying
    *  ssl pointer and open variable.  It is inteneded to be used only when the parent object is 
    *  going to be destroyed immediately.  This constructor is added for Sun's SUNPro compiler 
    *  compatibility.
    */
    ITCPStream(const ITCPStream& i);
  
  
    //! destructor - note: TCP is not freed
    ~ITCPStream();
  
  
    virtual IStreamBase& operator>>(char&);
    virtual IStreamBase& operator>>(unsigned char&);
    
    virtual IStreamBase& operator>>(short&);
    virtual IStreamBase& operator>>(unsigned short&);
    
    virtual IStreamBase& operator>>(bool&);
    
    virtual IStreamBase& operator>>(int&);
    virtual IStreamBase& operator>>(unsigned int&);
    
    virtual IStreamBase& operator>>(long long&);
    virtual IStreamBase& operator>>(unsigned long long&);
    
    virtual IStreamBase& operator>>(double&);
    virtual IStreamBase& operator>>(float&);
    
    //! input streaming of std strings
    virtual IStreamBase& operator>>(std::string& s);
      
      
    using IStreamBase::operator>>;
      
    bool is_open() const { return _open; }
      
    // get a single char off of the stream
    virtual void get(char& );
      
  private:
    //! wrapper for read - handles case of 0 byte reads
    int tcpRead(void* buf, int num);
  
    //! socket descriptor
    int _sd;
    //! open flag
    bool _open;
    
  };
};


#endif
