/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __i_text_stream_hpp
#define __i_text_stream_hpp

#include <iostream>

#include "istreambase.hpp"

#include <string>

namespace MynahSA { 

  /** override class for standard streams - provides
  *  management of unsigned character and character types.
  */
  class ITextStream : public IStreamBase {
  public:
    //! constructor - takes an input stream
    ITextStream(std::istream& i);
    
    
    //! copy constructor 
    ITextStream(const ITextStream&);
  
    //! destructor
    virtual ~ITextStream();
  
    
    /** stream in a character - note the character is encoded as an integer to prevent
    *  storage of unprintable characters on the stream.
    */
    virtual IStreamBase& operator>>(char&);
    
    /** stream in an unsigned character - note the character is encoded as an integer to prevent
    *  storage of unprintable characters on the stream.
    */
    virtual IStreamBase& operator>>(unsigned char&);
    
    //! instream a short
    virtual IStreamBase& operator>>(short&);
    
    //! instream an unsigned short
    virtual IStreamBase& operator>>(unsigned short&);
    
    //! instream a bool
    virtual IStreamBase& operator>>(bool&);
    
    //! instream an int
    virtual IStreamBase& operator>>(int&);
    
    //! instream an unsigned int
    virtual IStreamBase& operator>>(unsigned int&);
    
    //! instream a long long
    virtual IStreamBase& operator>>(long long&);
    
    //! instream an unsigned long long
    virtual IStreamBase& operator>>(unsigned long long&);
    
    //! instream a double
    virtual IStreamBase& operator>>(double&);
    
    //! instream a float
    virtual IStreamBase& operator>>(float&);
  
    // enable base class operator methods
    using IStreamBase::operator>>;
  
  
    //! unformatted character input overload
    virtual void get(char& c);
    
    //! requires formatting for strings - imagine a string with numbers at the start etc...
    virtual IStreamBase& operator>>(std::string& s);
    
  
  private:
    std::istream& _is;
  };
};



#endif
