/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/


#ifndef __mk_cert_hpp
#define __mk_cert_hpp

#include <openssl/pem.h>
#include <openssl/conf.h>
#include <openssl/x509v3.h>
#ifndef OPENSSL_NO_ENGINE
#include <openssl/engine.h>
#endif

namespace MynahSA { 
  
  /** mkcert - a procedure for making an OpenSSL certificate with some default parameters.  This function is
   *           a straight re-implementation of the mkcert function provided with the OpenSSL package.
   *
   * @param x509p - an output parameter for a new certificate.  Pass in the address of an X509 pointer, which should be 0.
   * @param pkeyp - an output parameter for a new RSA private key.
   * @param bits - the number of bits for the RSA private key (1024 is recommended).
   * @param serial - the serial number for the certificate.
   * @param days - the number of valid days for the certificate.
   * @return - non-zero indicates success 
   */
  int mkcert(X509 **x509p, EVP_PKEY **pkeyp, int bits, int serial, int days);
  
  /** A private function for mkcert - it is used for adding custom values to a certificate.
   * 
   * @param cert - the certificate (non-null!)
   * @param nid  - the Numerical IDentifier for the value to be added
   * @param value - the string to be associated with NID
   * @return 
   */
  int add_ext(X509 *cert, int nid, char *value);
};

#endif
