/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __o_binary_stream_hpp
#define __o_binary_stream_hpp

#include <iostream>

#include "ostreambase.hpp"

namespace MynahSA { 
  /** Class OBinaryStream - an output binary stream that is bound on top of an std::ostream.
   */
  class OBinaryStream : public OStreamBase { 
  public:
    //! constructor - takes an std::ostream output stream by reference to place data on
    OBinaryStream(std::ostream& os);
    
    //! copy constructor
    OBinaryStream(const OBinaryStream& os);
    
    //! Destructor
    virtual ~OBinaryStream();
    
    //! ostream char
    virtual OStreamBase& operator<<(const char);
    
    //! ostream unsigned char
    virtual OStreamBase& operator<<(const unsigned char);
    
    //! ostream short
    virtual OStreamBase& operator<<(const short);
    
    //! ostream unsigned short
    virtual OStreamBase& operator<<(const unsigned short);
    
    //! ostream bool
    virtual OStreamBase& operator<<(const bool);
    
    //! ostream int
    virtual OStreamBase& operator<<(const int);
    
    //! ostream uint
    virtual OStreamBase& operator<<(const unsigned int);
    
    //! ostream long long
    virtual OStreamBase& operator<<(const long long);
    
    //! ostream unsigned long
    virtual OStreamBase& operator<<(const unsigned long long);
    
    //! ostream double
    virtual OStreamBase& operator<<(const double);
    
    //! ostream float
    virtual OStreamBase& operator<<(const float);   
    
    // using statement is required to allow base class methods to be used
    using OStreamBase::operator<<;
    
  private:
    //! Reference to provided std::ostream
    std::ostream& _os;
  
  };

};

#endif
