/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __o_stream_base_hpp
#define __o_stream_base_hpp

#include <list>
#include <map>
#include <string>
#include <vector>

#include <stdexcept>

#include <mynahsa/exceptionbase.hpp>

namespace MynahSA { 

  /** Class OStreamWriteError - an exception class for stream write errors.
  */
  class OStreamWriteError : public ExceptionBase { 
  public:
    //! constructor
    OStreamWriteError(const std::string& c);
    //! destructor
    ~OStreamWriteError() throw();
  };
  
  
  /** Class OStreamBase is a base class for all output stream implementations.
  *  It provides implementations for the most common std:: containers - and 
  *  provides a mechanism for connecting them with the c++ basic types.
  */
  class OStreamBase {
  public:
    //! constructor
    OStreamBase();
    
    //! virtual destructor
    virtual ~OStreamBase();
    
    //! ostream char
    virtual OStreamBase& operator<<(const char) = 0;
    //! ostream unsigned char
    virtual OStreamBase& operator<<(const unsigned char) = 0;
    //! ostream short
    virtual OStreamBase& operator<<(const short) = 0;
    //! ostream unsigned short
    virtual OStreamBase& operator<<(const unsigned short) = 0;
    //! ostream int
    virtual OStreamBase& operator<<(const int) = 0;
    //! ostream unsigned int
    virtual OStreamBase& operator<<(const unsigned int) = 0;
    //! ostream bool
    virtual OStreamBase& operator<<(const bool) = 0;
    //! ostream long long
    virtual OStreamBase& operator<<(const long long) = 0;
    //! ostream unsigned long long
    virtual OStreamBase& operator<<(const unsigned long long) = 0;
    //! ostream double
    virtual OStreamBase& operator<<(const double) = 0;
    //! ostream float
    virtual OStreamBase& operator<<(const float) = 0;
    
    //! we provide an implementation for strings, but user classes may override.
    virtual OStreamBase& operator<<(const std::string&);
  
  };
};

#endif
