/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __o_tcp_stream_hpp
#define __o_tcp_stream_hpp

#include <iostream>

#include <stdexcept>

#include <string>

#include "ostreambase.hpp"


namespace MynahSA { 
  /** class OTCPStream is an output stream designed to place the builtin C++ types onto an TCP stream
  *
  *    This class does not take ownership of the file descriptor passed into it.  
  *
  *    This class buffers data prior to writes - It is recommended that the buffer size be close to
  *    the path mtu.  No automatic mechanism is provided for handling this, and one may be introduced 
  *    in the future.
  *
  */
  class OTCPStream : public OStreamBase {
  public:
    //! constructor - takes an input stream
    OTCPStream(int s);
  
    //! copy constructor - needed to work around unspecified copy constructor behavior in SUNPro c++
    OTCPStream(const OTCPStream& s);
  
    //! destructor - note: TCP is not freed
    ~OTCPStream();
  
  
    virtual OStreamBase& operator<<(const char);
    virtual OStreamBase& operator<<(const unsigned char);
    
    virtual OStreamBase& operator<<(const short);
    virtual OStreamBase& operator<<(const unsigned short);
    
    virtual OStreamBase& operator<<(const bool);
    
    virtual OStreamBase& operator<<(const int);
    virtual OStreamBase& operator<<(const unsigned int);
    
    virtual OStreamBase& operator<<(const long long);
    virtual OStreamBase& operator<<(const unsigned long long);
    
    virtual OStreamBase& operator<<(const double);
    virtual OStreamBase& operator<<(const float);
    
    //! output streaming of std strings
    virtual OStreamBase& operator<<(const std::string& s);
      
    // using declaration to allow base method to be used.
    using OStreamBase::operator<<;
      
    //! force the internal buffers to be flushed
    void flush();
      
  private:
    //! File descriptor - to access the underlying transport layer
    int _sd;
    
    //! local buffer
    char* _buffer;
    
    //! buffer pointer - points to the current back of the buffer
    unsigned int _buffPtr;
  
    //! TCP_write replacement - performs buffer management
    int tcpWrite(const void* data, unsigned int size);
    
  };

};


#endif
