/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/


#ifndef __request_response_handler_hpp
#define __request_response_handler_hpp

#include <mynahsa/spimpl.hpp>


#include "iobase.hpp"

namespace MynahSA { 
  
  /** RequestResponseHandler is a handler object that deals with request objects
  *  and produces a response object for transfer back to clients.  This class
  *  servers as a base class for derived implementations.  The derived classes
  *  created from this base must be thread safe!  The ssl server will 
  *  instantiate a single thread per communications instance - therefore, all
  *  data must be handled in a thread safe manner!
  */
  class RequestResponseHandler { 
  public:
    //! default constructor
    RequestResponseHandler();
    //! virtual destructor
    virtual ~RequestResponseHandler();
  
    //! Request -> Response handler
    virtual SHARED_PTR<IoBase> operator()(const SHARED_PTR<IoBase>&) = 0;
  
  };
};



#endif
