/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __as_init_hpp
#define __as_init_hpp

namespace MynahSA {
  /** Initialize archive and stream library.  This function must be called
  *  prior to using the archiving and streaming library...  This function
  *  will initialize winsock on the Win32 platform, and perform the necessary
  *  ssl startup - if required.
  *
  * If you are using neither the TCP streams nor the SSL streams, it is safe
  * to call this function with false for both parameters.  Calling this function
  * with initSSL == true and initTCP == false will cause problems on Win32 if
  * networking is required - TCP must be initialized on Win32 to use any form
  * of network communication.
  */
  int saInit(bool initTCP = true, bool initSSL = true);
};
#endif
