/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __ssl_archive_stream_hpp
#define __ssl_archive_stream_hpp

#include <mynahsa/iarchive.hpp>
#include <mynahsa/oarchive.hpp>
#include <mynahsa/isslstream.hpp>
#include <mynahsa/osslstream.hpp>

#include <mynahsa/archivestreambase.hpp>


#include <iostream>

namespace MynahSA { 

  //! typedef to remove template parameter
  typedef IArchive<ISSLStream> ISSLArchiveStream;
  
  //! typdef to remove template parameter
  typedef OArchive<OSSLStream> OSSLArchiveStream;
  
  /** Class SSLArchiveStream amalgmates both input and output ssl stream types into a
    *   bidrectional stream for reading and writing C++ types, and types extended using
    *   the serialize concept interface.  
    */
  class SSLArchiveStream : public ArchiveStreamBase,
                           public ISSLArchiveStream, 
                           public OSSLArchiveStream {
  
  public:
  
    //! constructor - takes an open and ready SSL as a parameter
    SSLArchiveStream(SSL* s);
  
    //! copy constructor - for a workaround in SUNPro tools
    SSLArchiveStream(const SSLArchiveStream& s);
  
    //! destructor - does nothing
    ~SSLArchiveStream();
  
    //! returns true if stream is still open
    bool is_open() const;
    
    //! close the stream - SSL shutdown call
    void close();
    
    //! we need to provide an override to avoid ambiguity in calling this function  
    void registerConstructor(const std::string& name, 
                             const SHARED_PTR<Archive::ArchiveConstructor>& cons);
    
    
    /** Clear unique pointer references.  See MynahSA::Archive::clearUPR() for more details.
     * 
     */
    void clearUPR();
  
  private:
    //! ssl pointer - only needed for is_open
    SSL* _ssl;
    //! - input ssl stream: we hold an instance here because archivers do not own their underlying streams
    ISSLStream is;
    //! - output ssl stream: we hold an instance here because archivers do not own their underlying streams
    OSSLStream os;
  
  };
};  

#endif
