/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __ssl_connection_cert_verifier_hpp
#define __ssl_connection_cert_verifier_hpp

#include "sslconnectionverifier.hpp"

namespace MynahSA { 

  /** Class SSLConnectionCertVerifier performs basic X509 certificate verification
    * on an incoming SSL connection.  The requirements of a client are that: <br>
    * 1) It provide a valid certificate.  No certificate -> rejection.<br>
    * 2) The Common Name field identifing the client matches the network name associated
    *    with the connecting host.
    *
    * Notes: The SSLConnectionCertVerifier::operator( SSL* ) function will never be
    *        invoked if the certificate presented by the client is not verified during
    *        the connection process.  This mechanism is normally used with a certificate
    *        authority file.
    */
  class SSLConnectionCertVerifier : public SSLConnectionVerifier { 
  public:
    //! constructor
    SSLConnectionCertVerifier();
    
    //! virtual destructor
    virtual ~SSLConnectionCertVerifier();
    
    //! operator function - returning true allows the connection to proceed
    virtual bool operator()(SSL*) const;
  };
};

#endif
