/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __ssl_connection_verifier_hpp
#define __ssl_connection_verifier_hpp

#include <openssl/ssl.h>

namespace MynahSA { 

  /** Class SSLConnectionVerifier is a functor base class.  Its purpose is to perform
    * verification on a recently established SSL connection.  The operator() function
    * returns true if the connection is verified - and allowed to communicate.  Otherwise,
    * false is returned and the server will close the connection without further action.
    * <br><br>
    * Note: this base class implementation accepts ALL incoming ssl connections.
    */
  class SSLConnectionVerifier { 
  public:
    //! default constructor
    SSLConnectionVerifier();
    
    //! virtual destructor
    virtual ~SSLConnectionVerifier();
    
    //! virtual operator - returning true allows SSL connection, false closes
    virtual bool operator()(SSL* s) const;
  
  };
};

#endif
