/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __sslinit_h 
#define __sslinit_h

namespace MynahSA { 
  /** function used for initializing the SSL library.  Note: This function must be called prior to using any
   *  OpenSSL functionality.  It is responsible for configuring the OpenSSL library, initializing thread 
   *  support by providing the correct mutex constructor functions, and initializing the random number
   *  generator.  Valgrind hits are expected in this function because of the way OpenSSL deals with 
   *  uninitialized variables.
   */
  void sslInit();
};

#endif
