/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __stream_constructor_hpp
#define __stream_constructor_hpp

#include <mynahsa/archivestreambase.hpp>

namespace MynahSA { 

  /** The StreamConstructor functor is used in the SSLConnectionManager to correctly initialize 
    * the stream.  The purpose of this function is to provide registration functions for the the input
    * stream implementation through a functor interface.
    * 
    * This is necessary so that the input archive instance that is embedded inside each StreamType is
    * prepared to reconstruct objects by pointer onto a stream.  To use SSLConnectionManager correctly,
    * you must provide a derived instance of this class containing the correct calls to register each 
    * streamable data type with the input archive instance.
    *
    * Note: Stream instances must support copy construction 
    *
    */
  class StreamConstructor { 
  public:
    //! constructor
    StreamConstructor() {
    }
    
    //! destructor
    virtual ~StreamConstructor() {
    }
    
    //! register constructors for a stream
    virtual void operator()(ArchiveStreamBase&) const=0;
  };
};

#endif
