/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __string_cast_hpp
#define __string_cast_hpp

#include <sstream>
#include <stdexcept>
#include <string>

namespace MynahSA { 

  class StringCastException : std::logic_error { 
  public:
    StringCastException(const std::string& str) : std::logic_error(str.c_str()) { 
    }
    StringCastException(const char* c) : std::logic_error(c) {
    }
  };  

  template<class T>
  T StringCast(const char* c) { 
    std::ostringstream os;
    os << c;
    std::istringstream is(os.str());
    T rv;
    is >> rv;
    if (!is) { 
      throw StringCastException("Error in string conversion");
    }
    return rv;
  }
  
  template<class T>
  T StringCast(const std::string& c) { 
    std::ostringstream os;
    os << c;
    std::istringstream is(os.str());
    T rv;
    is >> rv;
    if (!is) { 
      throw StringCastException("Error in string conversion");
    }
    return rv;
  }
};

#endif

