/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __tcp_archive_stream_hpp
#define __tcp_archive_stream_hpp

#include <mynahsa/iarchive.hpp>
#include <mynahsa/oarchive.hpp>
#include <mynahsa/itcpstream.hpp>
#include <mynahsa/otcpstream.hpp>
#include <mynahsa/archivestreambase.hpp>


#include <iostream>

namespace MynahSA { 

  //! typedef to remove template parameter
  typedef IArchive<ITCPStream> ITCPArchiveStream;
  
  //! typdef to remove template parameter
  typedef OArchive<OTCPStream> OTCPArchiveStream;
  
  /** Class TCPArchiveStream amalgmates both input and output ssl stream types into a
    *   bidrectional stream for reading and writing C++ types, and types extended using
    *   the serialize concept interface.  
    */
  class TCPArchiveStream : public ArchiveStreamBase, 
                           public ITCPArchiveStream, 
                           public OTCPArchiveStream {
  
  public:
  
    //! constructor - takes an open and ready TCP as a parameter
    TCPArchiveStream(int sd);
  
    //! copy constructor - for a workaround in SUNPro tools
    TCPArchiveStream(const TCPArchiveStream& s);
  
    //! destructor - does nothing
    ~TCPArchiveStream();
  
    //! returns true if stream is still open
    bool is_open() const;
    
    //! close the stream - TCP shutdown call
    void close();
    
    //! we need to provide an override to avoid ambiguity in calling this function  
    void registerConstructor(const std::string& name, 
                             const SHARED_PTR<Archive::ArchiveConstructor>& cons);
    
    /** Clear unique pointer references.  See MynahSA::Archive::clearUPR() for more details.
     * 
     */
    void clearUPR();
    
    
  private:
    //! ssl pointer - only needed for is_open
    int _sd;
    
    //! - input ssl stream: we hold an instance here because archivers do not own their underlying streams
    ITCPStream is;
    //! - output ssl stream: we hold an instance here because archivers do not own their underlying streams
    OTCPStream os;
  
  };
};


#endif
