/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __tcp_connection_manager_hpp
#define __tcp_connection_manager_hpp

#include <mynahsa/requestresponsehandler.hpp>
#include <mynahsa/streamconstructor.hpp>


namespace MynahSA { 

  /** class TCPConnectionManager - This class is designed to manage an individual TCP connection.
  *
  *  Design:  TCPServer manages ALL incoming connections.  When an incomming connection is requested
  *    the TCPServer spawns a thread to manage all I/O over that particular TCP connection.  The class
  *    responsible for handling the connection is TCPConnectionManager.  TCPConnectionManager performs
  *    some basic stream initialization, then proceeds to stream objects off of the stream and 
  *    reconstruct them in memory.  Once the in-memory image is ready, the request/response handler
  *    is invoked to transform an object received off of the stream into a response.  The response is then
  *    placed back onto the stream for the client to process.
  *
  *  Notes: 
  *    TCPConnection manager and descendant classes must be thread safe.
  *    StreamType must support copy construction.
  */
  class TCPConnectionManager { 
  public:
    /** Constructor
     * 
     * @param handler - Object Handler - embeds the behavior of the server in this functional object
     * @param cons - constructor - provides constructor objects for the ITCPArchive, allowing it to recover
     *               objects off of the stream.
     * @return - Nothing
     */
    TCPConnectionManager(RequestResponseHandler& handler,
                         const StreamConstructor& cons);
  
    /** Destructor
     * 
     * @return Nothing
     */
    ~TCPConnectionManager();
  
    /** operator() - takes file descriptor fd and performs TCP i/o on it.
     * 
     * @param fd - File Descriptor to network port attached to tcp client
     */
    void operator()(int fd);
  
  private:
  
    //! pointer to response handler object
    RequestResponseHandler& _handler;
    
    //! pointer to stream object constructor
    const StreamConstructor& _streamConstructor;
    
  
  };
};

#endif
