/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __tcp_server_h
#define __tcp_server_h

#include <stdexcept>
#include <mynahsa/tcpconnectionmanager.hpp>

#define ENABLE_THREADED_SERVER

namespace MynahSA { 
  
  /** TCP server class */
  class TCPServer {
  public:
    /** TCPServer constructor - takes a ConnectionManager object and a port to operate on
    *  port - the port to answer requests on
    */
    TCPServer(TCPConnectionManager& sobj, 
              int port);
  
    //! destructor - close master socket
    ~TCPServer();
  

    /** Check for new connections, block for wait_t amount of seconds,
    *  if no connection is made within wait_t function returns.  This must
    *  be called regularly from within main 
    */
    void checkClients(int wait_t=0);
  
  private:
    // Create and attach socket.
    void bindPort();
  
    //! port server is to operate on
    int _port;
  
    //! FD for server
    int _master;
    
    //! server object
    TCPConnectionManager& _serverObject;
  };
};

#endif
